/*
 * Decompiled with CFR 0.152.
 */
package org.tigris.subversion.svnclientadapter.javahl;

import java.io.File;
import java.net.MalformedURLException;
import java.util.Date;
import org.tigris.subversion.javahl.Status;
import org.tigris.subversion.svnclientadapter.ISVNStatus;
import org.tigris.subversion.svnclientadapter.SVNNodeKind;
import org.tigris.subversion.svnclientadapter.SVNRevision;
import org.tigris.subversion.svnclientadapter.SVNStatusKind;
import org.tigris.subversion.svnclientadapter.SVNUrl;
import org.tigris.subversion.svnclientadapter.javahl.JhlConverter;

public class JhlStatus
implements ISVNStatus {
    private Status _s;

    public JhlStatus(Status status) {
        this._s = status;
    }

    public SVNUrl getUrl() {
        try {
            String string = this._s.getUrl();
            return string != null ? new SVNUrl(string) : null;
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public SVNRevision.Number getLastChangedRevision() {
        if (this._s.getReposLastCmtAuthor() == null) {
            return JhlConverter.convertRevisionNumber(this._s.getLastChangedRevisionNumber());
        }
        if (this._s.getReposLastCmtRevisionNumber() == 0L) {
            return null;
        }
        return JhlConverter.convertRevisionNumber(this._s.getReposLastCmtRevisionNumber());
    }

    public Date getLastChangedDate() {
        if (this._s.getReposLastCmtAuthor() == null) {
            return this._s.getLastChangedDate();
        }
        return this._s.getReposLastCmtDate();
    }

    public String getLastCommitAuthor() {
        if (this._s.getReposLastCmtAuthor() == null) {
            return this._s.getLastCommitAuthor();
        }
        return this._s.getReposLastCmtAuthor();
    }

    public SVNStatusKind getTextStatus() {
        return JhlConverter.convertStatusKind(this._s.getTextStatus());
    }

    public SVNStatusKind getPropStatus() {
        return JhlConverter.convertStatusKind(this._s.getPropStatus());
    }

    public SVNRevision.Number getRevision() {
        return JhlConverter.convertRevisionNumber(this._s.getRevisionNumber());
    }

    public boolean isCopied() {
        return this._s.isCopied();
    }

    public String getPath() {
        return this._s.getPath();
    }

    public File getFile() {
        return new File(this.getPath()).getAbsoluteFile();
    }

    public SVNNodeKind getNodeKind() {
        SVNNodeKind sVNNodeKind = this._s.getReposLastCmtAuthor() == null ? JhlConverter.convertNodeKind(this._s.getNodeKind()) : JhlConverter.convertNodeKind(this._s.getReposKind());
        return sVNNodeKind;
    }

    public SVNUrl getUrlCopiedFrom() {
        try {
            String string = this._s.getUrlCopiedFrom();
            return string != null ? new SVNUrl(string) : null;
        }
        catch (MalformedURLException malformedURLException) {
            return null;
        }
    }

    public SVNStatusKind getRepositoryTextStatus() {
        return JhlConverter.convertStatusKind(this._s.getRepositoryTextStatus());
    }

    public SVNStatusKind getRepositoryPropStatus() {
        return JhlConverter.convertStatusKind(this._s.getRepositoryPropStatus());
    }

    public String toString() {
        return this.getPath() + " " + this.getTextStatus().toString();
    }

    public File getConflictNew() {
        String string = this._s.getConflictNew();
        return string != null ? new File(this.getFile().getParent(), string).getAbsoluteFile() : null;
    }

    public File getConflictOld() {
        String string = this._s.getConflictOld();
        return string != null ? new File(this.getFile().getParent(), string).getAbsoluteFile() : null;
    }

    public File getConflictWorking() {
        String string = this._s.getConflictWorking();
        return string != null ? new File(this.getFile().getParent(), string).getAbsoluteFile() : null;
    }

    public Date getLockCreationDate() {
        return this._s.getLockCreationDate();
    }

    public String getLockOwner() {
        return this._s.getLockOwner();
    }

    public String getLockComment() {
        return this._s.getLockComment();
    }
}

